#The Basic Bass Model   
# Parameter estimation by nonlinear least squares method 
# Script by S. Kido (June 14,2013)
#  m:  the market potential (market size)
#  p:  coefficient of innovation
#  q:  coefficient of imitation
# Input data
#  For your case ; replace the following values and title labels
Sales <- c(64.940,91.614,91.691,113.741,456.187,458.556,653.687)
subtitle  <- c(" Case Data : EV-cars 2005-2011(Japan)")
n <- length(Sales)       # number of actual data point
Tm <- 1:n                # time (period) for computation
#Tmdlt <- (1:100) / 5    # use this script for smoothing the graph 
　Tmdlt <- 1:20         # use sequential values for computation and prediction of input data 
#
# followings are initial values for estimation
#p,q : average across studies(P=0.03, Q=0.38)
# m  : cum.value of input data (M=5000) unit:1000
IntM <-c(5000)
IntP <-c(0.03)
IntQ <-c(0.38)
#
Cumsales <- cumsum(Sales)
# compute coefficient m,p,q
B_Bass.nls <- nls(Sales ~ M * ( ((P+Q)^2 / P) * exp(-(P+Q) * Tm) ) /(1+(Q/P)*exp(-(P+Q)*Tm))^2, 
     start = list(M=IntM, P=IntP, Q=IntQ) )
summary(B_Bass.nls)
BBcoef <- coef(B_Bass.nls)
m <- BBcoef[1]
p <- BBcoef[2]
q <- BBcoef[3]
# setting the starting value for M to the recorded total sales.
nmkt<- exp(-(p+q) * Tmdlt)
# par(cex=0.9, pch=1,mfrow=c(1,1),col=1,lty=1,lwd=1)
# dividing graph area :number of graph frames:mfrow=c(2,1)
par(cex=0.9, pch=1,mfrow=c(1,1),col=1,lty=1,lwd=1,mfrow=c(2,1))
# plot Adopters per period 
BBprd <- m * ( (p+q)^2 / p ) * nmkt / (1 + (q/p) * nmkt)^2
BBprd
# use years for graph
Tmdlt <-2005:2024 # year 
Tm    <-2005:2011
#
plot(Tmdlt, BBprd ,
main="EV Adopters per year ",
 ,xlab = "Year ",ylab = "Adopters", 
 type='l',col="red")
points(Tm, Sales)
lines(Tmdlt,BBprd ,col="red")
legend("topright", c("actual points","estimated lines"))
# plot cum. Adopters per period
BBcumd <- m * (1 - nmkt)/(1 + (q/p)*nmkt)
BBcumd
#
Tmdlt <-2005:2024 # year 
Tm    <-2005:2011
#
plot(Tmdlt, BBcumd , 
main="EV Cumulative Adopters per year ",
sub=subtitle 
,xlab = "Year",ylab = "Cumulative Adopters", 
type='l',col="red")
points(Tm, Cumsales)
lines(Tmdlt,BBcumd ,col="green")
legend("bottomright", c("actual points","estimated lines"))
# output  data to csv.files
write.csv(BBcoef ,"~/Desktop/bass_parameters_ev_cars.csv") 
write.csv(cbind(BBprd,BBcumd),"~/Desktop/bass_adopters_ev_cars.csv")
